--[[----------------------------------------------------------------------------
JudgeMyJPEG - Plugin Info Provider
Affiche les informations du plugin dans le gestionnaire de plugins
------------------------------------------------------------------------------]]

local LrView = import 'LrView'
local bind = LrView.bind

return {
	sectionsForTopOfDialog = function(f, propertyTable)
		return {
			{
				title = 'À propos de JudgeMyJPEG',

				f:row {
					f:static_text {
						title = 'JudgeMyJPEG analyse vos photos avec l\'IA et vous donne un score détaillé ainsi que des recommandations d\'amélioration.',
						width_in_chars = 50,
						height_in_lines = 3,
						wrap = true,
					},
				},

				f:row {
					f:static_text {
						title = 'Version: 1.0.0',
						width_in_chars = 30,
					},
				},

				f:row {
					f:static_text {
						title = 'Site web: www.judgemyjpeg.fr',
						width_in_chars = 30,
					},
				},

				f:row {
					f:push_button {
						title = 'Obtenir un token MCP',
						action = function()
							LrHttp.openUrlInBrowser('https://www.judgemyjpeg.fr/dashboard')
						end,
					},
				},
			},

			{
				title = 'Configuration',

				f:row {
					f:static_text {
						title = 'Token MCP (requis):',
						width = LrView.share 'label_width',
					},
					f:password_field {
						value = bind 'mcpToken',
						width_in_chars = 40,
						immediate = true,
					},
				},

				f:row {
					f:static_text {
						title = 'Ton d\'analyse:',
						width = LrView.share 'label_width',
					},
					f:popup_menu {
						value = bind 'analysisMode',
						items = {
							{ title = 'Professionnel', value = 'professional' },
							{ title = 'Roast', value = 'roast' },
							{ title = 'Apprentissage', value = 'learning' },
						},
						width_in_chars = 20,
					},
				},

				f:row {
					f:static_text {
						title = 'Langue:',
						width = LrView.share 'label_width',
					},
					f:popup_menu {
						value = bind 'language',
						items = {
							{ title = 'Français', value = 'fr' },
							{ title = 'English', value = 'en' },
							{ title = 'Español', value = 'es' },
							{ title = 'Deutsch', value = 'de' },
							{ title = 'Italiano', value = 'it' },
							{ title = 'Português', value = 'pt' },
						},
						width_in_chars = 20,
					},
				},
			},
		}
	end,
}
