# 📸 JudgeMyJPEG - Plugin Lightroom Classic

Plugin officiel Adobe Lightroom Classic pour l'analyse IA de photos avec JudgeMyJPEG.

> **⚠️ DEUX VERSIONS DISPONIBLES**
> - **Version Legacy** : Ancienne version (fichiers à la racine de lightroom-plugin/)
> - **Version MCP** : Nouvelle version avec serveur MCP (dossier `JudgeMyJPEG.lrdevplugin/`)

---

# 🆕 Version MCP (Recommandée)

Plugin utilisant le nouveau serveur MCP pour une meilleure performance et fiabilité.

## 🚀 Fonctionnalités

- **Analyse individuelle** : Score sur 100 + conseils détaillés
- **Battle Photo A/B** : Comparez 2 photos et découvrez la meilleure
- **3 modes d'analyse** : Professionnel, Roast, Apprentissage
- **Support multilingue** : 6 langues disponibles
- **Serveur MCP** : Architecture moderne avec cache et rate limiting
- **Interface native** : Intégration complète au workflow Lightroom

## 📋 Prérequis

- Adobe Lightroom Classic 6.0+ (SDK 9.0 recommandé)
- Compte JudgeMyJPEG avec **Token MCP**
- Photos accessibles via URL publique (Cloudinary, Imgur, etc.)
- Connexion internet active

## 🔧 Installation Version MCP

1. **Télécharger** le dossier `JudgeMyJPEG.lrdevplugin`
2. **Lightroom** → `Fichier` → `Gestionnaire de modules externes`
3. **Ajouter** → Sélectionner le dossier `JudgeMyJPEG.lrdevplugin`
4. **Activer** le plugin JudgeMyJPEG

## ⚙️ Configuration MCP

1. **Obtenir un Token MCP** sur [judgemyjpeg.fr/dashboard](https://www.judgemyjpeg.fr/dashboard)
2. **Lightroom** → `Fichier` → `Gestionnaire de modules externes` → `JudgeMyJPEG`
3. **Coller le Token MCP** dans le champ prévu
4. **Configurer** les préférences :
   - **Ton d'analyse** : Professional, Roast, ou Apprentissage
   - **Langue** : FR, EN, ES, DE, IT, PT

## 📖 Utilisation Version MCP

### Analyse Individuelle
1. **Sélectionner** une photo dans le catalogue
2. **Menu** `Bibliothèque` → `Modules externes` → `Analyser la photo sélectionnée`
3. **Entrer** l'URL publique de la photo
4. **Consulter** le score et les recommandations !

### Battle Photo A/B
1. **Sélectionner** exactement 2 photos
2. **Menu** `Bibliothèque` → `Modules externes` → `Comparer 2 photos (A/B)`
3. **Entrer** les URLs des deux photos
4. **Découvrir** la gagnante avec analyse comparative

### Filtrage par Score
1. Panneau `Métadonnées` → Afficher `JudgeMyJPEG`
2. Filtrer par score, mode, date d'analyse
3. Créer des collections intelligentes

## 🎭 Modes d'Analyse

| Mode | Description | Usage |
|------|-------------|-------|
| 👔 **Professionnel** | Analyse technique constructive | Apprentissage, conseils |
| 🔥 **Cassant** | Critique brutalement honnête | Feedback sans langue de bois |
| 🎯 **Expert** | Analyse ultra-technique | Niveau professionnel |

## 🏷️ Métadonnées Ajoutées

- **Score JudgeMyJPEG** : Note globale /100
- **Score Composition** : Cadrage, règle des tiers /15
- **Score Éclairage** : Qualité lumière /15
- **Score Netteté** : Mise au point /15
- **Score Exposition** : Histogramme /15
- **Score Créativité** : Originalité /15
- **Score Émotion** : Impact visuel /15
- **Score Narration** : Storytelling /10
- **Mode analyse** : Pro/Cassant/Expert
- **Date analyse** : Horodatage

## 💡 Workflows Recommandés

### 📊 Tri des Photos
```
1. Importer les photos
2. Analyse par lot (Mode Pro)
3. Filtrer par Score ≥ 80
4. Créer collection "Meilleures photos"
```

### 🎯 Amélioration Technique
```
1. Filtrer Score Exposition < 10
2. Corriger en développement
3. Re-analyser pour mesurer progrès
```

### 🏆 Sélection Portfolio
```
1. Analyse Mode Expert
2. Filtrer Score ≥ 85
3. Vérifier estimation commerciale
4. Exporter pour portfolio
```

## 🔧 API et Paramètres

### Configuration Avancée
- **Analyses simultanées** : 1-5 (recommandé: 3)
- **Délai entre requêtes** : 500-3000ms
- **Qualité export** : 50-100% JPEG
- **Taille maximale** : 1024-4096px

### Endpoints API
- **Analyse simple** : `/api/photos/analyze`
- **Analyse par lot** : `/api/batch-analyze`
- **Status API** : `/api/status`

## 🚨 Limitations & Bonnes Pratiques

### Limitations
- **Taille fichier** : Max 10MB par photo
- **Formats supportés** : JPEG, PNG, TIFF
- **Rate limiting** : 5 analyses/minute par utilisateur
- **Analyses simultanées** : Max 5 en parallèle

### Bonnes Pratiques
- **Export qualité** : 90% minimum pour analyse précise
- **Taille optimale** : 2048px côté long
- **Batch analysis** : 20 photos max par lot
- **Délai réseau** : 2 secondes entre requêtes

## 🔍 Dépannage

### Erreurs Communes

| Erreur | Cause | Solution |
|--------|-------|---------|
| "API Key invalide" | Clé incorrecte | Vérifier sur judgemyjpeg.fr |
| "Fichier introuvable" | Photo hors ligne | Reconnecter le disque |
| "Erreur réseau" | Connexion coupée | Vérifier internet/firewall |
| "Timeout" | Surcharge API | Réduire analyses simultanées |

### Logs de Debug
```lua
-- Activer les logs dans LrLogger
local logger = LrLogger('JudgeMyJPEG')
logger:enable('print') -- Affiche dans console
```

## 📞 Support

- **Site** : [judgemyjpeg.fr](https://www.judgemyjpeg.fr)
- **Email** : contact@judgemyjpeg.com
- **Documentation** : Guide intégré au plugin
- **Version** : 1.0.0

## 🔄 Changelog

### v1.0.0 (2025-01-18)
- ✅ Première version stable
- ✅ Analyse individuelle et par lot
- ✅ 3 modes d'analyse complets
- ✅ Support métadonnées Lightroom
- ✅ Interface de configuration
- ✅ Guide utilisateur intégré

## 📄 Licence

Plugin développé par JudgeMyJPEG pour Adobe Lightroom Classic.
Utilisation soumise aux conditions de service JudgeMyJPEG.

---

**🎯 Développé avec passion pour améliorer votre workflow photo !**